% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/functional-spectral-density.R
\name{Spec}
\alias{Spec}
\title{Compute Spectral Density of Functional Time Series}
\usage{
Spec(X, W = Epanechnikov_kernel, B.T = (dim(X)[1])^(-1/5),
  only.diag = FALSE, trace = FALSE, demean = TRUE, subgrid = FALSE,
  subgrid.density = 10, verbose = 0,
  subgrid.density.relative.to.bandwidth = TRUE)
}
\arguments{
\item{X}{A \eqn{T \times nbasis} matrix of containing the coordinates of the FTS
expressed in a basis. Each row corresponds to a time point, and each column
corresponds to the coefficient of the corresponding basis function of the  FTS.}

\item{W}{The weight function used to smooth the periodogram operator. Set by
default to be the Epanechnikov kernel}

\item{B.T}{The bandwidth of frequencies over which the periodogram operator
is smoothed. If \code{B.T=0},  the periodogram operator is returned.}

\item{only.diag}{A logical variable to choose if the function only computes
the marginal spectral density of each basis coordinate
(\code{only.diag=TRUE}). \code{only.diag=FALSE} by default, the full spectral
density operator is computed .}

\item{trace}{A logical variable to choose if only the trace of the spectral
density operator is computed. \code{trace=FALSE} by default.}

\item{demean}{A logical variable to choose if the FTS is centered before
computing its spectral density operator.}

\item{subgrid}{A logical variable to choose if the spectral density operator
is only returned for a subgrid of the Fourier frequencies, which can be
useful in large datasets to reduce memory usage. \code{subgrid=FALSE} by
default.}

\item{subgrid.density}{Only used if \code{subgrid=TRUE}. Specifies the
approximate number of frequencies within the bandwidth over which the
periodogram operator is smoothed.}

\item{verbose}{A  variable to show the progress of the computations. By
default, \code{verbose=0}.}

\item{subgrid.density.relative.to.bandwidth}{logical parameter to specify if
\code{subgrid.density} is specified relative to the bandwidth parameter \code{B.T}}
}
\value{
A list containing the following elements:
\describe{
 \item{spec}{The estimated spectral density operator. The first dimension corresponds to the different frequencies over which the spectral density operators are estimated.}
 \item{omega}{The frequencies over which the spectral density is estimated.}
 \item{m}{The number of Fourier frequencies over which the periodogram operator was smoothed.}
 \item{bw}{The equivalent Bandwidth used in the weight function W(), as defined in Bloomfield (1976, p.201).}
 \item{weight}{The weight function used to smooth the periodogram operator.}
 \item{kappa.square}{The L2 norm of the weight function W.}
 }
}
\description{
This function estimates the spectral density operator of a Functional Time Series (FTS)
}
\examples{
ma.scale1=c(-1.4,2.3,-2)
a1=Generate_filterMA(10, 10, MA.len=3, ma.scale=ma.scale1)
X=Simulate_new_MA(a1, T.len=512, noise.type='wiener')
ans=Spec(X, trace=FALSE, only.diag=FALSE)
plot(ans)
plot(Spec(X, trace=FALSE, only.diag=FALSE, subgrid=TRUE, subgrid.density=10,
subgrid.density.relative.to.bandwidth=FALSE))
rm(ans)
}
\references{
\link{spec.pgram} function of R.

\cite{ Bloomfield, P. (1976) "Fourier Analysis of Time Series:
An Introduction", Wiley.}

\cite{Panaretos, V. M. and Tavakoli, S., "Fourier Analysis of Functional Time Series", Ann. Statist. Volume 41, Number 2 (2013), 568-603.}
}

