% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestMetaLayer.R
\name{TestMetaLayer}
\alias{TestMetaLayer}
\title{TestMetaLayer Class}
\description{
This class implement a predicted meta layer. A \link{TestMetaLayer} can only exist as unique element of a \link{Training} object.

A predicted meta layer can only contain a \link{TestData} object.
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{TestMetaLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestMetaLayer-new}{\code{TestMetaLayer$new()}}
\item \href{#method-TestMetaLayer-print}{\code{TestMetaLayer$print()}}
\item \href{#method-TestMetaLayer-getTesting}{\code{TestMetaLayer$getTesting()}}
\item \href{#method-TestMetaLayer-getTestData}{\code{TestMetaLayer$getTestData()}}
\item \href{#method-TestMetaLayer-openAccess}{\code{TestMetaLayer$openAccess()}}
\item \href{#method-TestMetaLayer-closeAccess}{\code{TestMetaLayer$closeAccess()}}
\item \href{#method-TestMetaLayer-getAccess}{\code{TestMetaLayer$getAccess()}}
\item \href{#method-TestMetaLayer-setTestData}{\code{TestMetaLayer$setTestData()}}
\item \href{#method-TestMetaLayer-checkTestDataExist}{\code{TestMetaLayer$checkTestDataExist()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$new(id, testing)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Testing meta-layer id.}

\item{\code{testing}}{\code{Testing}\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-getTesting"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-getTesting}{}}}
\subsection{Method \code{getTesting()}}{
Getter of the current testing object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$getTesting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current testing object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-getTestData"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-getTestData}{}}}
\subsection{Method \code{getTestData()}}{
Getter of the training dataset stored on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$getTestData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{TestData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-openAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-openAccess}{}}}
\subsection{Method \code{openAccess()}}{
Open access to the meta layer. A meta learner is only
modifiable if the access is opened.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$openAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-closeAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-closeAccess}{}}}
\subsection{Method \code{closeAccess()}}{
Close access to the meta layer to avoid accidental
modification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$closeAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-getAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-getAccess}{}}}
\subsection{Method \code{getAccess()}}{
Getter of the current access to the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$getAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-setTestData"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-setTestData}{}}}
\subsection{Method \code{setTestData()}}{
Create and set an \link{TestData} object to the current
new meta learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$setTestData(id, ind_col, data_frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)} \cr
ID of the \link{TestData} object to be instanciated.}

\item{\code{ind_col}}{\code{character(1)} \cr
Name of individual column IDs.}

\item{\code{data_frame}}{\code{data.frame(1)} \cr
\code{data.frame} of layer specific predictions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestMetaLayer-checkTestDataExist"></a>}}
\if{latex}{\out{\hypertarget{method-TestMetaLayer-checkTestDataExist}{}}}
\subsection{Method \code{checkTestDataExist()}}{
Check whether a new data has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestMetaLayer$checkTestDataExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
}
