% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{animation_config}
\alias{animation_config}
\title{Create Animation Configuration for G6 Graphs}
\usage{
animation_config(
  delay = NULL,
  direction = c("forward", "alternate", "alternate-reverse", "normal", "reverse"),
  duration = NULL,
  easing = NULL,
  fill = c("none", "auto", "backwards", "both", "forwards"),
  iterations = NULL
)
}
\arguments{
\item{delay}{Animation delay time in milliseconds. The time to wait before the
animation begins. Must be a non-negative numeric value.}

\item{direction}{Animation playback direction. Options:
\itemize{
\item \code{"forward"}: Plays normally (default)
\item \code{"alternate"}: Plays forward, then in reverse
\item \code{"alternate-reverse"}: Plays in reverse, then forward
\item \code{"normal"}: Same as forward
\item \code{"reverse"}: Plays in reverse direction
}}

\item{duration}{Animation duration in milliseconds. The length of time the
animation will take to complete one cycle. Must be a non-negative numeric value.}

\item{easing}{Animation easing function. Controls the rate of change during
the animation. Common values include "linear", "ease", "ease-in", "ease-out",
"ease-in-out", or cubic-bezier values.}

\item{fill}{Fill mode after animation ends. Options:
\itemize{
\item \code{"none"}: Element returns to its initial state when animation ends (default)
\item \code{"auto"}: Follows the rules of the animation effect
\item \code{"backwards"}: Element retains first keyframe values during delay period
\item \code{"both"}: Combines forwards and backwards behavior
\item \code{"forwards"}: Element retains final keyframe values after animation ends
}}

\item{iterations}{Number of times the animation should repeat. A value of
\code{Inf} will cause the animation to repeat indefinitely. Must be a
non-negative numeric value.}
}
\value{
A list containing animation configuration that can be passed to \code{\link[=g6_options]{g6_options()}}.
}
\description{
Configures animation settings for G6 graph elements. These settings control
how graph elements animate when changes occur.
}
\details{
Animation configuration allows fine-tuning the timing and behavior of animations
in G6 graphs. This includes controlling the duration, delay, easing function,
direction, and other aspects of how graph elements animate.
}
\examples{
# Basic animation with duration
config <- animation_config(
  duration = 500
)

# Complex animation configuration
config <- animation_config(
  delay = 100,
  duration = 800,
  easing = "ease-in-out",
  direction = "alternate",
  fill = "forwards",
  iterations = 2
)

# Infinite animation
config <- animation_config(
  duration = 1000,
  easing = "linear",
  iterations = Inf
)
}
