% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgraph.R
\name{hGraph}
\alias{hGraph}
\title{Create multiplicity graphs using ggplot2}
\usage{
hGraph(
  nHypotheses = 4,
  nameHypotheses = paste("H", (1:nHypotheses), sep = ""),
  alphaHypotheses = 0.025/nHypotheses,
  m = matrix(array(1/(nHypotheses - 1), nHypotheses^2), nrow = nHypotheses) -
    diag(1/(nHypotheses - 1), nHypotheses),
  fill = 1,
  palette = grDevices::gray.colors(length(unique(fill)), start = 0.5, end = 0.8),
  labels = LETTERS[1:length(unique(fill))],
  legend.name = " ",
  legend.position = "none",
  halfWid = 0.5,
  halfHgt = 0.5,
  trhw = 0.1,
  trhh = 0.075,
  trprop = 1/3,
  digits = 5,
  trdigits = 2,
  size = 6,
  boxtextsize = 4,
  legend.textsize = size * 2.5,
  arrowsize = 0.02,
  radianStart = if ((nHypotheses)\%\%2 != 0) {
     pi * (1/2 + 1/nHypotheses)
 } else
    {
     pi * (1 + 2/nHypotheses)/2
 },
  offset = pi/4/nHypotheses,
  xradius = 2,
  yradius = xradius,
  x = NULL,
  y = NULL,
  wchar = "\u03b1"
)
}
\arguments{
\item{nHypotheses}{number of hypotheses in graph}

\item{nameHypotheses}{hypothesis names}

\item{alphaHypotheses}{alpha-levels or weights for ellipses}

\item{m}{square transition matrix of dimension `nHypotheses`}

\item{fill}{grouping variable for hypotheses}

\item{palette}{colors for groups}

\item{labels}{text labels for groups}

\item{legend.name}{text for legend header}

\item{legend.position}{text string or x,y coordinates for legend}

\item{halfWid}{half width of ellipses}

\item{halfHgt}{half height of ellipses}

\item{trhw}{transition box width}

\item{trhh}{transition box height}

\item{trprop}{proportion of transition arrow length where transition box is placed}

\item{digits}{number of digits to show for alphaHypotheses}

\item{trdigits}{digits displayed for transition weights}

\item{size}{text size in ellipses}

\item{boxtextsize}{transition text size}

\item{legend.textsize}{legend text size}

\item{arrowsize}{size of arrowhead for transition arrows}

\item{radianStart}{radians from origin for first ellipse; nodes spaced equally in clockwise order with centers on an ellipse by default}

\item{offset}{rotational offset in radians for transition weight arrows}

\item{xradius}{horizontal ellipse diameter on which ellipses are drawn}

\item{yradius}{vertical ellipse diameter on which ellipses are drawn}

\item{x}{x coordinates for hypothesis ellipses if elliptical arrangement is not wanted}

\item{y}{y coordinates for hypothesis ellipses if elliptical arrangement is not wanted}

\item{wchar}{character for alphaHypotheses in ellipses; defaults to the Unicode escape sequence \code{\\u03b1} (Greek letter alpha).
See \href{https://en.wikipedia.org/wiki/List_of_Unicode_characters}{list of Unicode characters} for a more comprehensive character list.}
}
\value{
A `ggplot` object with a multi-layer multiplicity graph
}
\description{
Plots a multiplicity graph defined by user inputs.
The graph can also be used with the gMCP package to evaluate a set of
nominal p-values for the tests of the hypotheses in the graph.
}
\details{
See vignette **Multiplicity graphs formatting using ggplot2**
for explanation of formatting.
}
\examples{
# Use Cairo PDF device for better Unicode character support
# when checking the package. Needed for R >= 4.4.0.
if (names(dev.cur()) == "pdf") {
  fn <- attr(.Device, "filepath")
  fn0 <- "gMCPLite-Ex.pdf"
  if (!is.null(fn) && fn == fn0) {
    dv <- cairo_pdf(fn0)
    on.exit(dev.off(dv), add = TRUE)
  }
}

# Defaults: note clockwise ordering
hGraph(5)
# Add colors (default is 3 gray shades)
hGraph(3,fill=1:3)
# Colorblind palette
cbPalette <- c("#999999", "#E69F00", "#56B4E9", "#009E73",
               "#F0E442", "#0072B2", "#D55E00", "#CC79A7")
hGraph(6,fill=as.factor(1:6),palette=cbPalette)
# Use a hue palette
hGraph(4,fill=factor(1:4),palette=scales::hue_pal(l=75)(4))
# different alpha allocation, hypothesis names and transitions
alphaHypotheses <- c(.005,.007,.013)
nameHypotheses <- c("ORR","PFS","OS")
m <- matrix(c(0,1,0,
              0,0,1,
              1,0,0),nrow=3,byrow=TRUE)
hGraph(3,alphaHypotheses=alphaHypotheses,nameHypotheses=nameHypotheses,m=m)
# Custom position and size of ellipses, change text to multi-line text
# Adjust box width
# add legend in middle of plot
hGraph(3,x=sqrt(0:2),y=c(1,3,1.5),size=6,halfWid=.3,halfHgt=.3, trhw=0.6,
       palette=cbPalette[2:4], fill = c(1, 2, 2),
       legend.position = c(.6,.5), legend.name = "Legend:", labels = c("Group 1", "Group 2"),
       nameHypotheses=c("H1:\n Long name","H2:\n Longer name","H3:\n Longest name"))

}
