% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_distr.R
\name{distr_var}
\alias{distr_var}
\title{Compute Variance}
\usage{
distr_var(f, distr, param = NULL, par_link = NULL)
}
\arguments{
\item{f}{Parameters. For the same parameters for all observations, a numeric vector. For individual parameters for each observation, a numeric matrix with rows corresponding to observations.}

\item{distr}{A distribution.}

\item{param}{A parametrization of the distribution.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to keeping the original link for all parameters.}
}
\value{
The variance.
}
\description{
A function computing variance for a given distribution.
}
\examples{
# Variance for the negative binomial distribution
distr_var(f = c(13.50, 0.03), distr = "negbin")

}
\seealso{
\code{\link[gasmodel:distr]{distr()}}
}
