% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcript.R
\name{get_introns}
\alias{get_introns}
\title{Calculate Intron Positions Based on Exons}
\usage{
get_introns(data)
}
\arguments{
\item{data}{A dataframe containing `start` and `end` positions of transcripts.
Optional columns are `type` (exon or UTR), `transcript` (containing unique
transcript IDs), and `strand` (indicating the direction, forward or reverse,
of each transcript).}
}
\value{
A dataframe with the original exons and the calculated introns, sorted
  by transcript and start position. Each row includes the `start`, `end`,
  `type` (exon, UTR or intron), `transcript`, and `strand` for each segment.
}
\description{
This function takes a dataset containing transcript information and calculates
the start and end positions of introns based on the positions of exons. It
generates a combined dataframe including both the original exons and the
calculated introns.
}
