% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{na_extension_wkb}
\alias{na_extension_wkb}
\alias{na_extension_wkt}
\alias{na_extension_large_wkb}
\alias{na_extension_large_wkt}
\alias{na_extension_wkb_view}
\alias{na_extension_wkt_view}
\alias{na_extension_geoarrow}
\title{Extension type definitions for GeoArrow extension types}
\usage{
na_extension_wkb(crs = NULL, edges = "PLANAR")

na_extension_wkt(crs = NULL, edges = "PLANAR")

na_extension_large_wkb(crs = NULL, edges = "PLANAR")

na_extension_large_wkt(crs = NULL, edges = "PLANAR")

na_extension_wkb_view(crs = NULL, edges = "PLANAR")

na_extension_wkt_view(crs = NULL, edges = "PLANAR")

na_extension_geoarrow(
  geometry_type,
  dimensions = "XY",
  coord_type = "SEPARATE",
  crs = NULL,
  edges = "PLANAR"
)
}
\arguments{
\item{crs}{An object representing a CRS. For maximum portability,
it should implement \code{\link[wk:wk_crs_proj_definition]{wk::wk_crs_projjson()}}.}

\item{edges}{One of "PLANAR" or "SPHERICAL".}

\item{geometry_type}{One of "POINT", "LINESTRING", "POLYGON", "MULTIPOINT",
"MULTILINESTRING", "MULTIPOLYGON".}

\item{dimensions}{One of "XY", "XYZ", "XYM", or "XYZM"}

\item{coord_type}{One of "SEPARATE" or "INTERLEAVED"}
}
\value{
A \link[nanoarrow:as_nanoarrow_schema]{nanoarrow_schema}.
}
\description{
Extension type definitions for GeoArrow extension types
}
\examples{
na_extension_wkb(crs = "OGC:CRS84")
na_extension_geoarrow("POINT")

}
