% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{compare_adjacencies}
\alias{compare_adjacencies}
\title{Compare Adjacency Lists}
\usage{
compare_adjacencies(adj1, adj2, shp, zero = TRUE)
}
\arguments{
\item{adj1}{Required. A first adjacency list.}

\item{adj2}{Required. A second adjacency list.}

\item{shp}{shapefile to compare intersection types.}

\item{zero}{Boolean. Defaults to TRUE. Are adj1 and adj2 zero indexed?}
}
\value{
tibble with row indices to compare, and optionally columns which describe the
DE-9IM relationship between differences.
}
\description{
Compare Adjacency Lists
}
\examples{
data(towns)
rook <- adjacency(towns)
sf_rook <- lapply(sf::st_relate(towns, pattern = 'F***1****'), function(x) {
  x - 1L
})
compare_adjacencies(rook, sf_rook, zero = FALSE)
}
\concept{fix}
