% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_points_bearing.R
\name{geo_points_bearing}
\alias{geo_points_bearing}
\title{Bearing Between Two Latitude and Longitude Points}
\usage{
geo_points_bearing(coordinate_pair)
}
\arguments{
\item{coordinate_pair}{A matrix of latitude and longitude columns and two rows of points}
}
\value{
A vector of length 1 containing a bearing
}
\description{
Calculates the bearing angle in degrees between two latitude, longitude points
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 2) / 10000000,
            sample(-1147301410:-1241938690, 2) / 10000000
        ),
        ncol = 2
    )

# Calculate bearing
(gpb <- geo_points_bearing(sample_coord))

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        sample_coord[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
