% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggblend-package.R
\docType{package}
\name{ggblend-package}
\alias{ggblend-package}
\alias{ggblend}
\title{Blending and compositing for ggplot2}
\description{
\pkg{ggblend} is an R package that adds support for R 4.2 blend modes
(e.g. \code{"multiply"}, \code{"overlay"}, etc) to \pkg{ggplot2}.
}
\details{
The primary support for blending is provided by the \code{blend()} function,
which can be used to augment \code{\link[=ggplot]{ggplot()}} layers/geoms or lists of
layers/geoms in a \code{\link[=ggplot]{ggplot()}} specification.

For example, one can replace something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{df |>
  ggplot(aes(x, y)) +
  geom_X(...) +
  geom_Y(...) +
  geom_Z(...)
}\if{html}{\out{</div>}}

With something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{df |>
  ggplot(aes(x, y)) +
  geom_X(...) +
  geom_Y(...) |> blend("multiply") +
  geom_Z(...)
}\if{html}{\out{</div>}}

In order to apply a "multiply" blend to the layer with \code{geom_Y(...)}.
}
\section{Package options}{


The following global options can be set using \code{\link[=options]{options()}} to modify the
behavior of \pkg{ggblend}:
\itemize{
\item \code{"ggblend.check_blend"}: If \code{TRUE} (default), \code{\link[=blend]{blend()}} will warn if
you attempt to use a blend mode not supported by the current graphics
device, as reported by \code{dev.capabilities()$compositing}. Since this check
can be unreliable on some devices (they will report not support a blend
mode that they do support), you can disable this warning by setting this
option to \code{FALSE}.
\item \code{"ggblend.check_affine_transform"}: If \code{TRUE} (default), \code{\link[=affine_transform]{affine_transform()}} will warn if
you attempt to use a blend mode not supported by the current graphics
device, as reported by \code{dev.capabilities()$transformation}. Since this check
can be unreliable on some devices (they will report not support a blend
mode that they do support), you can disable this warning by setting this
option to \code{FALSE}.
}
}

