% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted.median}
\alias{weighted.median}
\alias{weighted.quantile}
\title{Weighted Median and Quantiles}
\source{
These functions are adapted from their homonyms developed by Adrian
Baddeley in the \code{spatstat} package.
}
\usage{
weighted.median(x, w, na.rm = TRUE, type = 2)

weighted.quantile(x, w, probs = seq(0, 1, 0.25), na.rm = TRUE, type = 4)
}
\arguments{
\item{x}{a numeric vector of values}

\item{w}{a numeric vector of weights}

\item{na.rm}{a logical indicating whether to ignore \code{NA} values}

\item{type}{Integer specifying the rule for calculating the median or
quantile, corresponding to the rules available for \code{stats:quantile()}.
The only valid choices are type=1, 2 or 4. See Details.}

\item{probs}{probabilities for which the quantiles should be computed, a
numeric vector of values between 0 and 1}
}
\value{
A numeric vector.
}
\description{
Compute the median or quantiles a set of numbers which have weights
associated with them.
}
\details{
The \code{i}th observation \code{x[i]} is treated as having a weight proportional to
\code{w[i]}.

The weighted median is a value \code{m} such that the total weight of data less
than or equal to \code{m} is equal to half the total weight. More generally, the
weighted quantile with probability \code{p} is a value \code{q} such that the total
weight of data less than or equal to \code{q} is equal to \code{p} times the total
weight.

If there is no such value, then
\itemize{
\item if \code{type = 1}, the next largest value is returned (this is the
right-continuous inverse of the left-continuous cumulative distribution
function);
\item if \code{type = 2}, the average of the two surrounding values is returned
(the average of the right-continuous and left-continuous inverses);
\item if \code{type = 4}, linear interpolation is performed.
}

Note that the default rule for \code{weighted.median()} is \code{type = 2}, consistent
with the traditional definition of the median, while the default for
\code{weighted.quantile()} is \code{type = 4}.
}
\examples{
x <- 1:20
w <- runif(20)
weighted.median(x, w)
weighted.quantile(x, w)
}
