% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pvalue.R
\name{add_pvalue}
\alias{add_pvalue}
\title{Add p-value}
\usage{
add_pvalue(
  location = c("caption", "annotation"),
  caption = "{p.value}",
  prepend_p = TRUE,
  pvalue_fun = format_p,
  rho = 0,
  ...
)
}
\arguments{
\item{location}{string indicating where to place p-value. Must be one of
\code{c("caption", "annotation")}}

\item{caption}{string to be placed as the caption/annotation. String will
be processed with \code{glue::glue()}, and the default is \code{"{p.value}"}}

\item{prepend_p}{prepend \code{"p="} to formatted p-value}

\item{pvalue_fun}{function to round and style p-value with}

\item{rho}{argument passed to  \code{survival::survdiff(rho=)}}

\item{...}{arguments passed to \code{ggplot2::annotate()}. Commonly used arguments
are \verb{x=} and \verb{y=} to place the p-value at the specified coordinates on the plot.}
}
\value{
a ggplot2 figure
}
\description{
\itemize{
\item \code{add_pvalue("caption")}: Add a p-value to the figure via \code{ggplot2::labs(caption=)}
\item \code{add_pvalue("annotation")}: Add a p-value text annotation via \code{ggplot2::annotation("text")}
}

P-values are calculated with \code{survival::survdiff()} or \code{tidycmprsk::glance()}.
Examples of custom placement located in the help file for \code{survfit_p()}.

When a competing risks figure includes multiple outcomes, only the p-value
comparing stratum for the \emph{first} outcome can be placed.
}
\examples{
survfit2(Surv(time, status) ~ surg, df_colon) \%>\%
  ggsurvfit() +
  add_pvalue(caption = "Log-rank {p.value}") +
  scale_ggsurvfit()

survfit2(Surv(time, status) ~ surg, df_colon) \%>\%
  ggsurvfit() +
  add_pvalue("annotation", size = 5) +
  scale_ggsurvfit()
}
\seealso{
\code{survfit_p()}
}
