% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwmx2.R
\name{summary.fit_gnss_ts_ngl}
\alias{summary.fit_gnss_ts_ngl}
\title{Extract estimated parameters from a \code{fit_gnss_ts_ngl}}
\usage{
\method{summary}{fit_gnss_ts_ngl}(object, scale_parameters = FALSE, ...)
}
\arguments{
\item{object}{A \code{fit_gnss_ts_ngl} object.}

\item{scale_parameters}{A \code{boolean} indicating whether or not to scale estimated parameters so that the returned estimated trend is provided in m/year instead of m/day. Default is FALSE.}

\item{...}{Additional parameters.}
}
\description{
Extract estimated parameters from a \code{fit_gnss_ts_ngl}
}
\examples{
x <- download_station_ngl("P820")
fit1 <- gmwmx2(x, n_seasonal = 2, component = "N", stochastic_model = "wn + pl")
summary(fit1)
summary(fit1, scale_parameters = TRUE)
fit2 <- gmwmx2(x, n_seasonal = 2, component = "N", stochastic_model = "wn + fl")
summary(fit2)

}
