% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{compute_distance_matrix}
\alias{compute_distance_matrix}
\title{\eqn{p}-distance matrix computation}
\usage{
compute_distance_matrix(z, p = 2)
}
\arguments{
\item{z}{A \eqn{n\times 2} matrix with the two-dimensional points}

\item{p}{The \eqn{p} parameter of the distance-\eqn{p}.  It
defaults to 2.}
}
\value{
The distance-\eqn{p} of the points.
}
\description{
It computes the distance matrix of a set of \eqn{n}
two-dimensional points given by a \eqn{n\times 2} matrix using
the distance-\eqn{p} with \eqn{p=2} by default.
}
\details{
Given a set of \eqn{n} points \eqn{\{z_j\}_{j=1,...,n}}, the
distance matrix is a \eqn{n\times n} symmetric matrix with
matrix elements \deqn{d_{ij} = d(z_i,z_j)} computed using the
distance-\eqn{p} given by \deqn{d_p(x,y) = \left(\sum_i
    (x_i-y_i)^p\right)^{\frac{1}{p}}}.
}
\examples{
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)

}
\seealso{
\link{compute_p_distance} computes the distance-\eqn{p},
\link{compute_tour_distance} computes tour distances.  A distance
matrix can also be computed using \link{dist}.
}
\author{
Cesar Asensio
}
