% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period-scale.R
\name{scale_x_grates_period}
\alias{scale_x_grates_period}
\title{Period scale}
\usage{
scale_x_grates_period(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  format = "\%Y-\%m-\%d",
  n,
  offset
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_period>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{format}{Format to use for dates.

Value is used by \code{format.Date()} and can be any input acceptable by that
function.}

\item{n}{\verb{[integer]}

Number of days in each period.}

\item{offset}{\verb{[integer]}

Number of days used in original grouping for the offset from the Unix Epoch.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for an \verb{<grates_period>} vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) withAutoprint(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist

# Calculate the total of infections across 14 day periods offset from
# the first date
x <- linelist$date_of_infection
x <- as_period(x, n = 14, offset = min(x, na.rm = TRUE))
dat <- aggregate(list(cases = x), by = list(period = x), FUN = length)
head(dat)

(period_plot <- ggplot2::ggplot(dat, ggplot2::aes(period, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw() +
    ggplot2::theme(
        axis.text.x = ggplot2::element_text(
            angle = 45,
            hjust = 1
        )
    ) +
    ggplot2::xlab(""))

# To change defaults we must explicitly state the value of n and
# offset when calling the scale function
period_plot + scale_x_grates_period(
    n.breaks = 2,
    n = 14,
    offset = min(x, na.rm = TRUE)
)
\dontshow{\}) # examplesIf}
}
