% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_residuals}
\alias{add_residuals}
\title{Add residuals from a model to a data frame}
\usage{
add_residuals(data, model, value = ".residual", ...)
}
\arguments{
\item{data}{a data frame containing values for the variables used to fit the
model. Passed to \code{\link[stats:residuals]{stats::residuals()}} as \code{newdata}.}

\item{model}{a fitted model for which a \code{\link[stats:residuals]{stats::residuals()}} method is
available. S3 method dispatch is performed on the \code{model} argument.}

\item{value}{character; the name of the variable in which model residuals
will be stored.}

\item{...}{additional arguments passed to methods.}
}
\value{
A data frame (tibble) formed from \code{data} and residuals from \code{model}.
}
\description{
Add residuals from a model to a data frame
}
