% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{anova.gsl_nls}
\alias{anova.gsl_nls}
\title{Anova tables}
\usage{
\method{anova}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{Additional objects inheriting from class \code{"gsl_nls"}.}
}
\value{
A data.frame object of class \code{"anova"} similar to \code{\link[stats]{anova}} representing the
analysis-of-variance table of the fitted model objects when printed.
}
\description{
Returns the analysis of variance (or deviance) tables for two or
more fitted \code{"gsl_nls"} objects.
}
\examples{
## data
set.seed(1)
n <- 25
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + 1 + rnorm(n, sd = 0.1)
)
## model
obj1 <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))
obj2 <- gsl_nls(fn = y ~ A * exp(-lam * x) + b, data = xy,
    start = c(A = 1, lam = 1, b = 0))

anova(obj1, obj2)
}
\seealso{
\code{\link[stats]{anova}}
}
