% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_footnote_spec}
\alias{opt_footnote_spec}
\title{Option to specify the formatting of footnote marks}
\usage{
opt_footnote_spec(data, spec_ref = NULL, spec_ftr = NULL)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{spec_ref, spec_ftr}{\emph{Specifications for formatting of footnote marks}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Specification of the footnote marks when behaving as footnote references
and as marks in the footer section of the table. This is a string
containing spec characters. The default is the spec string \code{"^i"}, which is
superscript text set in italics.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Modify the way footnote marks are formatted. This can be performed for those
footnote marks that alight to the targeted text in cells in various locations
in the table or the footnote marks that appear in the table footer. A simple
specification string can be provided for either or both types of marks in
\code{opt_footnote_spec()} . This function serves as a shortcut for using either
of \code{tab_options(footnotes.spec_ref = {spec})} or
\code{tab_options(footnotes.spec_ftr = {spec})}.
}
\section{Specification rules for the formatting of footnote marks}{


A footnote spec consists of a string containing control characters for
formatting. Not every type of formatting makes sense for footnote marks so
the specification is purposefully constrained to the following:
\itemize{
\item as superscript text (with the \code{"^"} control character) or regular-sized
text residing on the baseline
\item bold text (with \code{"b"}), italicized text (with \code{"i"}), or unstyled text
(don't use either of the \code{"b"} or \code{"i"} control characters)
\item enclosure in parentheses (use \code{"("} / \code{")"}) or square brackets (with
\code{"["} / \code{"]"})
\item a period following the mark (using \code{"."}); this is most commonly used in
the table footer
}

With the aforementioned control characters we could, for instance, format
the footnote marks to be superscript text in bold type with \code{"^b"}. We might
want the marks in the footer to be regular-sized text in parentheses, so the
spec could be either \code{"()"} or \code{"(x)"} (you can optionally use \code{"x"} as a
helpful placeholder for the marks).
}

\section{Examples}{


Use a modified version of \code{\link{sp500}} the dataset to create a \strong{gt} table with
row labels. We'll add two footnotes using the \code{tab_footnote()} function. We
can call \code{opt_footnote_spec()} to specify that the marks of the footnote
reference should be superscripts in bold, and, the marks in the footer
section should be enclosed in parentheses.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sp500 |>
  dplyr::filter(date >= "1987-10-14" & date <= "1987-10-25") |>
  dplyr::select(date, open, close, volume) |>
  dplyr::mutate(difference = close - open) |>
  dplyr::mutate(change = (close - open) / open) |>
  dplyr::mutate(day = vec_fmt_datetime(date, format = "E")) |>
  dplyr::arrange(-dplyr::row_number()) |>
  gt(rowname_col = "date") |>
  fmt_currency() |>
  fmt_number(columns = volume, suffixing = TRUE) |>
  fmt_percent(columns = change) |>
  cols_move_to_start(columns = day) |>
  cols_width(
    stub() ~ px(130),
    day ~ px(50),
    everything() ~ px(100)
  ) |>
  tab_footnote(
    footnote = "Commerce report on trade deficit.",
    locations = cells_stub(rows = 1)
  ) |>
  tab_footnote(
    footnote = "Black Monday market crash, representing the greatest
    one-day percentage decline in U.S. stock market history.",
    locations = cells_body(columns = change, rows = change < -0.15)
  ) |>
  opt_footnote_spec(spec_ref = "^xb", spec_ftr = "(x)")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_footnote_spec_1.png" alt="This image of a table was generated from the first code example in the `opt_footnote_spec()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-4
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
