% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hce.R
\name{plot.hce}
\alias{plot.hce}
\title{A plot method for \code{hce} objects}
\usage{
\method{plot}{hce}(x, fill = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{hce} created by \code{as_hce()}.}

\item{fill}{logical; if \code{TRUE} fill the area above the graph.}

\item{...}{additional arguments to be passed to \code{\link[base:plot]{base::plot()}} function.}
}
\value{
no return value, called for plotting.
}
\description{
Ordinal dominance graph for \code{hce} objects
}
\examples{
d <- as_hce(KHCE)
d$TRTP <- factor(d$TRTP, levels = c("P", "A"))
res <- calcWO(AVAL ~ TRTP, data = d)
# Ordinal Dominance Graph
plot(d, col = 3, type = 'l')
grid()
# Area above the Ordinal Dominance Graph
plot(d, fill = TRUE, col = "#865A4F", type = 'l', 
     lwd = 2, xlab = "Control", ylab = "Active")
legend("bottomright", legend = paste0("WP = ", round(res$WP, 5)))
abline(a = 0, b = 1, lwd = 2, lty = 2, col = "#999999")
}
\references{
Bamber D. "The area above the ordinal dominance graph and the area below the receiver operating characteristic graph." Journal of Mathematical Psychology 12.4 (1975): 387-415. \url{doi:10.1016/0022-2496(75)90001-2}
}
