% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{as_pfs_os}
\alias{as_pfs_os}
\title{Convert multi-state data to PFS and OS data}
\usage{
as_pfs_os(
  data,
  patient_vars,
  status = "status",
  time_stop = "time_stop",
  transition = "transition_id"
)
}
\arguments{
\item{data}{A multi-state dataset.}

\item{patient_vars}{Character vector of the names of patient specific variables.}

\item{status}{Character string with the name of the status variable (1 = event,
0 = censored).}

\item{time_stop}{Character string with the name of the stopping time variable
(i.e., time patient transitions from state \eqn{r} to state \eqn{s}).}

\item{transition}{Character string with the name of the variable identifying
a transition. The transition variable should be integer valued with values
1, 2, and 3 for the Stable -> Progression, Stable -> Death, and
Progression -> Death transitions, respectively.}
}
\value{
A \code{data.table} with one row per patient containing each variable in
\code{patient_vars}  as well as a time variable and status indicator for both
PFS (\code{pfs_status}, \code{pfs_time}) and OS (\code{os_time}, \code{os_status}).
}
\description{
Convert a multi-state dataset with irreversible transitions containing 3 health
states to a dataset with one row per patient and progression-free survival (PFS)
and overall survival (OS) time-to-event outcomes.
}
\examples{
as_pfs_os(onc3, patient_vars = c("patient_id", "strategy_name", "female", "age")) 

}
