% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_cell_to_lonlat}
\alias{hexify_cell_to_lonlat}
\title{Convert cell ID to longitude/latitude}
\usage{
hexify_cell_to_lonlat(cell_id, resolution, aperture)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution (integer >= 0)}

\item{aperture}{Grid aperture (3, 4, or 7)}
}
\value{
Data frame with lon_deg and lat_deg columns
}
\description{
Converts cell identifiers back to cell center coordinates.
This is the inverse of \code{\link{hexify_lonlat_to_cell}}.
}
\examples{
coords <- hexify_cell_to_lonlat(1702, resolution = 5, aperture = 3)
}
\seealso{
\code{\link{cell_to_lonlat}} for the recommended S4 interface,
\code{\link{hexify_lonlat_to_cell}} for the forward operation

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
