% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{text_color}
\alias{text_color}
\alias{text_color<-}
\alias{set_text_color}
\alias{map_text_color}
\title{Set the color of text in cells}
\usage{
text_color(ht)

text_color(ht) <- value

set_text_color(ht, row, col, value)

map_text_color(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix. Set to \code{NA} to reset to the default, which is \code{NA_character_}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}
}
\description{
Colors can be in any format understood by R:
\itemize{
\item A color name like \code{"darkred"}
\item A HTML string like \code{"#FF0000"}
\item The result of a function like \code{rgb(1, 0, 0)} or \code{grey(0.5)}
}
}
\examples{
text_color(jams) <- "blue"
text_color(jams)

set_text_color(jams, "red")
set_text_color(jams, 2:3, 1, "red")
map_text_color(jams, by_rows("red", "blue"))

}
\seealso{
Other formatting functions: 
\code{\link{background_color}()},
\code{\link{bold}()},
\code{\link{font}()},
\code{\link{font_size}()},
\code{\link{na_string}()},
\code{\link{number_format}()}
}
\concept{formatting functions}
