% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{TokenBucket-class}
\alias{TokenBucket-class}
\alias{TokenBucket}
\title{TokenBucket Class}
\description{
This class represents a token bucket, which is a rate limiting mechanism used
to control the frequency of certain actions or requests based on available tokens.
Tokens are added to the bucket at a specified rate and can be consumed when needed.
}
\section{Fields}{

\describe{
\item{\code{capacity}}{The maximum number of tokens in the bucket.}

\item{\code{tokens}}{The number of tokens currently available in the bucket.}

\item{\code{interval}}{The duration in seconds after which the bucket gets refilled.}

\item{\code{last_update}}{The timestamp of the last update to the bucket.}
}}


\examples{
\donttest{
try({
# create token bucket
bucket <- TokenBucket(
  capacity = 10,
  tokens = 10,
  intervall = 1,
  last_update = Sys.Time()
)

# add tokens to bucket
bucket$addTokens()

# check if a token is available
bucket$isTokenAvailable

# consume token
bucket$consumeToken
})
}
}
\keyword{classes}
