% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeatmapExpPlotly.R
\name{HeatmapExpPlotly}
\alias{HeatmapExpPlotly}
\title{HeatmapExpPlotly}
\usage{
HeatmapExpPlotly(x, ColorPanel, scale, cluster, show_names, NumGenes)
}
\arguments{
\item{x}{Numeric matrix of log-CPM values (genes × samples), e.g., from edgeR::cpm().}

\item{ColorPanel}{Character. Name of a continuous palette from the paletteer package.}

\item{scale}{Character. Scaling mode: "row", "column", or "none".}

\item{cluster}{Character or logical. Clustering option for dendrogram: "both", "row", "column", or "none".}

\item{show_names}{Character. One of "both", "row", "column", or "none" to display row/column labels.}

\item{NumGenes}{Integer. Number of top-variance genes to include in the heatmap.}
}
\value{
A Plotly object (heatmaply) representing the interactive heatmap.
}
\description{
Create an interactive heatmap of top variable genes using Heatmaply.
}
\details{
This function selects the highest-variance genes from a log-CPM matrix, transposes
the data, and renders an interactive heatmap via "heatmaply", using "pheatmap" call.
\enumerate{
\item Compute per-gene variance and select the top NumGenes.
\item Transpose the subsetted matrix so samples are rows.
\item Generate a temporary static heatmap with pheatmap to extract dendrograms.
\item Render an interactive heatmap with heatmaply::heatmaply().
}
}
