% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_evaluation.R
\name{calculate_auc}
\alias{calculate_auc}
\title{Calculate AUC Metrics}
\usage{
calculate_auc(
  network_table,
  ground_truth,
  return_plot = FALSE,
  line_color = "#1563cc",
  line_width = 1,
  tag_levels = "A"
)
}
\arguments{
\item{network_table}{A data frame of predicted network structure}

\item{ground_truth}{A data frame of ground truth network}

\item{return_plot}{Logical value indicating whether to generate plots}

\item{line_color}{Color for plot lines}

\item{line_width}{Width for plot lines}

\item{tag_levels}{Tag levels for plot annotations}
}
\value{
A list containing metrics and optional plots
}
\description{
Calculates AUROC and AUPRC metrics with optional visualization
}
\examples{
data("example_matrix")
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
calculate_auc(
  network_table,
  example_ground_truth,
  return_plot = TRUE
)
}
