% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{display}
\alias{display}
\alias{print_md}
\alias{print_html}
\alias{display.data.frame}
\alias{print_md.data.frame}
\alias{print_html.data.frame}
\title{Generic export of data frames into formatted tables}
\usage{
display(object, ...)

print_md(x, ...)

print_html(x, ...)

\method{display}{data.frame}(object, format = "markdown", ...)

\method{print_md}{data.frame}(x, ...)

\method{print_html}{data.frame}(x, ...)
}
\arguments{
\item{object, x}{A data frame.}

\item{...}{Arguments passed to other methods.}

\item{format}{String, indicating the output format. Can be \code{"markdown"} or
\code{"html"}. A special option is \code{"tt"}, which creates a \code{\link[tinytable:tt]{tinytable::tt()}}
object, where the output format is dependent on the context where the table
is used, i.e. it can be markdown format when \code{export_table()} is used in
markdown files, or LaTex format when creating PDFs etc.}
}
\value{
Depending on \code{format}, either an object of class \code{gt_tbl},
\code{tinytable}, or a character vector of class \code{knitr_kable}.
}
\description{
\code{display()} is a generic function to export data frames
into various table formats (like plain text, markdown, ...). \code{print_md()}
usually is a convenient wrapper for \code{display(format = "markdown")}.
Similar, \code{print_html()} is a shortcut for \code{display(format = "html")}.
See the documentation for the specific objects' classes.
}
\examples{
\dontshow{if (all(check_if_installed(c("gt", "tinytable"), quietly = TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
display(iris[1:5, ], format = "html")

display(iris[1:5, ], format = "tt")

display(iris[1:5, ], format = "markdown")
\dontshow{\}) # examplesIf}
}
