% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gride.R, R/gride_bayes.R, R/gride_mle.R
\name{gride}
\alias{gride}
\alias{print.gride_bayes}
\alias{summary.gride_bayes}
\alias{print.summary.gride_bayes}
\alias{plot.gride_bayes}
\alias{print.gride_mle}
\alias{summary.gride_mle}
\alias{print.summary.gride_mle}
\alias{plot.gride_mle}
\title{\code{Gride}: the Generalized Ratios ID Estimator}
\usage{
gride(
  X = NULL,
  dist_mat = NULL,
  mus_n1_n2 = NULL,
  method = c("mle", "bayes"),
  n1 = 1,
  n2 = 2,
  alpha = 0.95,
  nsim = 5000,
  upper_D = 50,
  burn_in = 2000,
  sigma = 0.5,
  start_d = NULL,
  a_d = 1,
  b_d = 1,
  ...
)

\method{print}{gride_bayes}(x, ...)

\method{summary}{gride_bayes}(object, ...)

\method{print}{summary.gride_bayes}(x, ...)

\method{plot}{gride_bayes}(x, ...)

\method{print}{gride_mle}(x, ...)

\method{summary}{gride_mle}(object, ...)

\method{print}{summary.gride_mle}(x, ...)

\method{plot}{gride_mle}(x, ...)
}
\arguments{
\item{X}{data matrix with \code{n} observations and \code{D} variables.}

\item{dist_mat}{distance matrix computed between the \code{n} observations.}

\item{mus_n1_n2}{vector of generalized order NN distance ratios.}

\item{method}{the chosen estimation method. It can be
\describe{
\item{\code{"mle"}}{maximum likelihood estimation;}
\item{\code{"bayes"}}{estimation with the Bayesian approach.}
}}

\item{n1}{order of the first NN considered. Default is 1.}

\item{n2}{order of the second NN considered. Default is 2.}

\item{alpha}{confidence level (for \code{mle}) or posterior probability in
the credible interval (\code{bayes}).}

\item{nsim}{number of bootstrap samples or posterior simulation to consider.}

\item{upper_D}{nominal dimension of the dataset (upper bound for the
maximization routine).}

\item{burn_in}{number of iterations to discard from the MCMC sample.
Applicable if \code{method = "bayes"}.}

\item{sigma}{standard deviation of the Gaussian proposal used in the MH step.
Applicable if \code{method = "bayes"}.}

\item{start_d}{initial value for the MCMC chain. If \code{NULL},
the MLE is used. Applicable if \code{method = "bayes"}.}

\item{a_d}{shape parameter of the Gamma prior distribution for \code{d}.
Applicable if \code{method = "bayes"}.}

\item{b_d}{rate parameter of the Gamma prior distribution for \code{d}.
Applicable if \code{method = "bayes"}.}

\item{...}{other arguments passed to specific methods.}

\item{x}{object of class \code{gride_mle}.
It is obtained using the output of the \code{gride} function when
\code{method = "mle"}.}

\item{object}{object of class \code{gride_mle}, obtained from the function
\code{gride_mle()}.}
}
\value{
a list containing the \code{id} estimate obtained with the Gride
method, along with the relative confidence or credible interval
(object \code{est}). The class of the output object changes according to the
chosen \code{method}. Similarly,
the remaining elements stored in the list reports a summary of the key
quantities involved in the estimation process, e.g.,
the NN orders \code{n1} and \code{n2}.
}
\description{
The function can fit the Generalized ratios ID estimator under both the
frequentist and the Bayesian frameworks, depending on the specification of
the argument \code{method}. The model is the direct extension of the
\code{TWO-NN} method presented in
\href{https://www.nature.com/articles/s41598-017-11873-y}{Facco et al., 2017}
. See also \href{https://www.nature.com/articles/s41598-022-20991-1}{Denti et al., 2022} \
for more details.
}
\examples{
\donttest{
 X  <- replicate(2,rnorm(500))
 dm <- as.matrix(dist(X,method = "manhattan"))
 res <- gride(X, nsim = 500)
 res
 plot(res)
 gride(dist_mat = dm, method = "bayes", upper_D =10,
 nsim = 500, burn_in = 100)
}
}
\references{
Facco E, D'Errico M, Rodriguez A, Laio A (2017). "Estimating the intrinsic
dimension of datasets by a minimal neighborhood information."
Scientific Reports, 7(1).
ISSN 20452322, \doi{10.1038/s41598-017-11873-y}.

Denti F, Doimo D, Laio A, Mira A (2022). "The generalized ratios intrinsic
dimension estimator."
Scientific Reports, 12(20005).
ISSN  20452322, \doi{10.1038/s41598-022-20991-1}.
}
