% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-doc.R
\docType{data}
\name{breast}
\alias{breast}
\title{Breast Cancer microarray experiment}
\format{
A data frame with 52 rows and multiple variables, including a binary \code{status} and gene-level measurements.
}
\source{
Dr. John Bartlett and Dr. Caroline Witton, Division of Cancer Sciences and Molecular Pathology, University of Glasgow, Glasgow Royal Infirmary.
}
\description{
This data set details a microarray experiment for 52 breast cancer patients. The binary variable \code{status} indicates whether or not the patient died of breast cancer (\code{status = 0}: did not die, \code{status = 1}: died). The other variables represent amplification or deletion of specific genes.
}
\details{
Unlike gene expression studies, this experiment focuses on measuring gene amplification or deletion-the number of DNA copies for a given genomic sequence. The goal is to identify key genomic markers distinguishing aggressive from non-aggressive breast cancer.

The experiment was conducted by Dr. John Bartlett and Dr. Caroline Witton in the Division of Cancer Sciences and Molecular Pathology at the University of Glasgow's Royal Infirmary.
}
\examples{
data(breast)
str(breast)
table(breast$status)

\dontrun{
  fit <- islasso.path(status ~ ., data = breast, family = binomial(),
                      alpha = 0, control = is.control(trace = 2L))
  temp <- GoF.islasso.path(fit)
  lambda.aic <- temp$lambda.min["AIC"]
  fit.aic <- islasso(status ~ ., data = breast, family = binomial(),
                     alpha = 0, lambda = lambda.aic)
  summary(fit.aic, pval = 0.05)
}

}
\references{
Augugliaro L., Mineo A.M. and Wit E.C. (2013). \emph{dgLARS: a differential geometric approach to sparse generalized linear models}, Journal of the Royal Statistical Society. Series B, Vol 75(3), 471-498.
Wit E.C. and McClure J. (2004). \emph{Statistics for Microarrays: Design, Analysis and Inference}, Chichester: Wiley.
}
\keyword{datasets}
