% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_i_stat.R
\name{get_i_stat}
\alias{get_i_stat}
\title{Download data sets by id (source: I.Stat)}
\usage{
get_i_stat(id_dataset,
           start_period=NULL,
           end_period=NULL,
           recent=FALSE,
           csv=FALSE,
           xlsx=FALSE,
           lang="both")
}
\arguments{
\item{id_dataset}{data set id}

\item{start_period}{Time value for the start (NULL by default)}

\item{end_period}{Time value for the end (NULL bu default)}

\item{recent}{False by default, if TRUE, the function retrieves data from last 10 years}

\item{csv}{False by default, if TRUE, the function saves the data set to directory as .csv}

\item{xlsx}{False by default, if TRUE, the function saves the data set to directory as .xlsx}

\item{lang}{Language parameter for labels ("ita" for Italian, "eng" for English)}
}
\value{
It returns the data set as data.frame. It can be saved to environment or as .csv/.xlsx.
}
\description{
Download data sets from I.Stat (old ISTAT provider). Alternatively, use get_istatdata to download data sets from IstatData (new ISTAT provider).
Note that in this first version of the package, only get_i_stat allows you to download variable labels, while get_istatdata has not this functionality yet.
The parameters "id_dataset" to download data sets can be found using list_i_stat function or search_i_stat function.
}
\note{
Downloading may take some time. Future versions will speed up the process.
}
\examples{
\donttest{get_i_stat("12_60")}
\donttest{get_i_stat("12_60", start_period=2015, end_period=2018)}
\donttest{get_i_stat("12_60", start_period=2015, end_period=2015)}
\donttest{get_i_stat("12_60", recent=TRUE, lang="eng")}
}
