% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{summary.keras.engine.training.Model}
\alias{summary.keras.engine.training.Model}
\alias{format.keras.engine.training.Model}
\alias{print.keras.engine.training.Model}
\title{Print a summary of a Keras model}
\usage{
\method{summary}{keras.engine.training.Model}(object, ...)

\method{format}{keras.engine.training.Model}(
  x,
  line_length = width - (11L * show_trainable),
  positions = NULL,
  expand_nested = FALSE,
  show_trainable = x$built && as.logical(length(x$non_trainable_weights)),
  ...,
  compact = TRUE,
  width = getOption("width")
)

\method{print}{keras.engine.training.Model}(x, ...)
}
\arguments{
\item{object, x}{Keras model instance}

\item{...}{for \code{summary()} and \code{print()}, passed on to \code{format()}. For
\code{format()}, passed on to \code{model$summary()}.}

\item{line_length}{Total length of printed lines}

\item{positions}{Relative or absolute positions of log elements in each line.
If not provided, defaults to \code{c(0.33, 0.55, 0.67, 1.0)}.}

\item{expand_nested}{Whether to expand the nested models. If not provided,
defaults to \code{FALSE}.}

\item{show_trainable}{Whether to show if a layer is trainable. If not
provided, defaults to \code{FALSE}.}

\item{compact}{Whether to remove white-space only lines from the model
summary. (Default \code{TRUE})}

\item{width}{the column width to use for printing.}
}
\value{
\code{format()} returns a length 1 character vector. \code{print()} returns the
model object invisibly. \code{summary()} returns the output of \code{format()}
invisibly after printing it.
}
\description{
Print a summary of a Keras model
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model}()},
\code{\link{keras_model_sequential}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
