% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\docType{class}
\name{KerasCallback}
\alias{KerasCallback}
\title{(Deprecated) Base R6 class for Keras callbacks}
\format{
An \link[R6:R6Class]{R6::R6Class} generator object
}
\value{
\link{KerasCallback}.
}
\description{
New custom callbacks implemented as R6 classes are encouraged to inherit from
\code{keras$callbacks$Callback} directly.
}
\details{
The \code{logs} named list that callback methods take as argument will
contain keys for quantities relevant to the current batch or epoch.

Currently, the \code{fit.keras.engine.training.Model()} method for sequential
models will include the following quantities in the \code{logs} that
it passes to its callbacks:
\itemize{
\item \code{on_epoch_end}: logs include \code{acc} and \code{loss}, and optionally include \code{val_loss} (if validation is enabled in \code{fit}), and \code{val_acc} (if validation and accuracy monitoring are enabled).
\item \code{on_batch_begin}: logs include \code{size}, the number of samples in the current batch.
\item \code{on_batch_end}: logs include \code{loss}, and optionally \code{acc} (if accuracy monitoring is enabled).
}
}
\section{Fields}{

\describe{
\item{\code{params}}{Named list with training parameters (eg. verbosity, batch size, number of epochs...).}

\item{\code{model}}{Reference to the Keras model being trained.}
}}

\section{Methods}{

\describe{
\item{\code{on_epoch_begin(epoch, logs)}}{Called at the beginning of each epoch.}
\item{\code{on_epoch_end(epoch, logs)}}{Called at the end of each epoch.}
\item{\code{on_batch_begin(batch, logs)}}{Called at the beginning of each batch.}
\item{\code{on_batch_end(batch, logs)}}{Called at the end of each batch.}
\item{\code{on_train_begin(logs)}}{Called at the beginning of training.}
\item{\code{on_train_end(logs)}}{Called at the end of training.}
}
}

\examples{
\dontrun{
library(keras)

LossHistory <- R6::R6Class("LossHistory",
  inherit = KerasCallback,

  public = list(

    losses = NULL,

    on_batch_end = function(batch, logs = list()) {
      self$losses <- c(self$losses, logs[["loss"]])
    }
  )
)
}
}
\keyword{internal}
