% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{get_custom_objects}
\alias{get_custom_objects}
\alias{set_custom_objects}
\title{Get/set the currently registered custom objects.}
\usage{
get_custom_objects()

set_custom_objects(objects = named_list(), clear = TRUE)
}
\arguments{
\item{objects}{A named list of custom objects, as returned by
\code{get_custom_objects()} and \code{set_custom_objects()}.}

\item{clear}{bool, whether to clear the custom object registry before
populating it with \code{objects}.}
}
\value{
An R named list mapping registered names to registered objects.
\code{set_custom_objects()} returns the registry values before updating, invisibly.
}
\description{
Custom objects set using \code{custom_object_scope()} are not added to the
global list of custom objects, and will not appear in the returned
list.
}
\note{
\code{register_keras_serializable()} is preferred over \code{set_custom_objects()} for
registering new objects.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_custom_objects()
}\if{html}{\out{</div>}}

You can use \code{set_custom_objects()} to restore a previous registry state.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# within a function, if you want to temporarily modify the registry,
function() \{
  orig_objects <- set_custom_objects(clear = TRUE)
  on.exit(set_custom_objects(orig_objects))

  ## temporarily modify the global registry
  # register_keras_serializable(....)
  # ....  <do work>
  # on.exit(), the previous registry state is restored.
\}
}\if{html}{\out{</div>}}
}

\seealso{
Other serialization utilities: \cr
\code{\link{deserialize_keras_object}()} \cr
\code{\link{get_registered_name}()} \cr
\code{\link{get_registered_object}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{serialize_keras_object}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{serialization utilities}
