% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagged_na.R
\name{tagged_na_to_user_na}
\alias{tagged_na_to_user_na}
\alias{tagged_na_to_regular_na}
\title{Convert tagged NAs into user NAs}
\usage{
tagged_na_to_user_na(x, user_na_start = NULL)

tagged_na_to_regular_na(x)
}
\arguments{
\item{x}{a vector, a data frame or a survey design}

\item{user_na_start}{minimum value of the new user na, if \code{NULL},
computed automatically (maximum of observed values + 1)}
}
\description{
\code{\link[=tagged_na_to_user_na]{tagged_na_to_user_na()}} is the opposite of \code{\link[=user_na_to_tagged_na]{user_na_to_tagged_na()}} and
convert tagged \code{NA} into user defined missing values (see \code{\link[=labelled_spss]{labelled_spss()}}).
}
\details{
\code{\link[=tagged_na_to_regular_na]{tagged_na_to_regular_na()}} converts tagged NAs into regular NAs.
}
\examples{
x <- c(1:5, tagged_na("a"), tagged_na("z"), NA)
x
print_tagged_na(x)
tagged_na_to_user_na(x)
tagged_na_to_user_na(x, user_na_start = 10)

y <- c(1, 0, 1, tagged_na("r"), 0, tagged_na("d"))
val_labels(y) <- c(
  no = 0, yes = 1,
  "don't know" = tagged_na("d"),
  refusal = tagged_na("r")
)
y
tagged_na_to_user_na(y, user_na_start = 8)
tagged_na_to_regular_na(y)
tagged_na_to_regular_na(y) \%>\% is_tagged_na()
}
