% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{lasso_vars}
\alias{lasso_vars}
\title{Most Relevant Features Using Lasso Regression}
\usage{
lasso_vars(
  df,
  variable,
  ignore = NULL,
  nlambdas = 100,
  nfolds = 10,
  top = 20,
  quiet = FALSE,
  seed = 123,
  ...
)
}
\arguments{
\item{df}{Dataframe. Any dataframe is valid as \code{ohse} will be applied to
process categorical values, and values will be standardize automatically.}

\item{variable}{Variable. Dependent variable or response.}

\item{ignore}{Character vector. Variables to exclude from study.}

\item{nlambdas}{Integer. Number of lambdas to be used in a search.}

\item{nfolds}{Integer. Number of folds for K-fold cross-validation (>= 2).}

\item{top}{Integer. Plot top n results only.}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}

\item{seed}{Numeric.}

\item{...}{Additional parameters passed to \code{ohse()}.}
}
\value{
List. Contains lasso model coefficients, performance metrics, the
actual model fitted and a plot.
}
\description{
Use Lasso regression to identify the most relevant variables that
can predict/identify another variable. You might want to compare
with \code{corr_var()} and/or \code{x2y()} results to compliment
the analysis No need to standardize, center or scale your data.
Tidyverse friendly.
}
\examples{
\dontrun{
# CRAN
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset

m <- lasso_vars(dft, Survived, ignore = c("Cabin"))
print(m$coef)
print(m$metrics)
plot(m$plot)
}
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}
}
\concept{Exploratory}
\concept{Machine Learning}
