% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqmix.R
\name{lqmix}
\alias{lqmix}
\title{Linear Quantile Mixture with TC and/or TV, discrete, random coefficients}
\usage{
lqmix(formula, randomTC = NULL, randomTV = NULL, group, time, G = NULL,
  m = NULL, data, qtl = 0.5, eps = 10^-5, maxit = 1000, se = TRUE,
  R = 50, start = 0, parInit = list(betaf = NULL, betarTC = NULL, betarTV
  = NULL, pg = NULL, delta = NULL, Gamma = NULL, scale = NULL),
  verbose = TRUE, posterior = FALSE, seed = NULL, parallel = FALSE)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}: a symbolic description of the model to be fitted}

\item{randomTC}{a one-sided formula of the form \code{~z1+z2+...+zr}, where \code{z1,..., zr} denote the variables associated to TC random coefficients (1 for the intercept)}

\item{randomTV}{a one-sided formula of the form \code{~w1+w2+...+wl}, where \code{w1,..., wl} denote the variables associated to TV random coefficients (1 for the intercept). Note that only TC variables are allowed}

\item{group}{a string indicating the grouping variable, i.e., the factor identifying the unit longitudinal measurements refer to}

\item{time}{a string indicating the time variable}

\item{G}{number of mixture components associated to TC random coefficients}

\item{m}{number of states associated to the TV random coefficients}

\item{data}{a data frame containing the variables named in \code{formula}, \code{randomTC}, \code{randomTV}, and \code{time}}

\item{qtl}{quantile to be estimated}

\item{eps}{tolerance level for (relative) convergence of the EM algorithm}

\item{maxit}{maximum number of iterations for the EM algorithm}

\item{se}{if set to TRUE, standard error are computed}

\item{R}{number of bootstrap samples for computing standard errors}

\item{start}{type of starting values (0 = deterministic, 1 = random, 2 = initial values in input)}

\item{parInit}{list of initial model parameters when \code{start=2}}

\item{verbose}{if set to FALSE, no printed output is given during the function execution}

\item{posterior}{if set to TRUE, posterior probabilities are given in output}

\item{seed}{an integer value for random numbers generation}

\item{parallel}{if set to TRUE, a parallelized code is use for standard error computation (if se=TRUE)}
}
\value{
Return an object of \code{\link{class}} \code{lqmix}. This is a list containing the following elements:
\item{betaf}{a vector containing fixed regression coefficients}
\item{betarTC}{a matrix containing the TC random coefficients, if present in the model}
\item{betarTV}{a matrix containing the TV random coefficients, if present in the model}
\item{pg}{the prior probabilities of the finite mixture associated to TC random coefficients, if present in the model}
\item{delta}{the initial probability vector of the hidden Markov chain associated to TV random coefficients, if present in the model}
\item{Gamma}{the transition probability matrix of the hidden Markov chain associated to TV random coefficients, if present in the model}
\item{scale}{the scale parameter}
\item{sigma.e}{the standard deviation of error terms}
\item{lk}{the log-likelihood at convergence of the EM algorithm}
\item{npar}{the total number of model parameters}
\item{aic}{the AIC value}
\item{bic}{the BIC value}
\item{qtl}{the estimated quantile}
\item{G}{the number of mixture components associated to TC random coefficients (if present)}
\item{m}{the number of hidden states associated to TV random coefficients (if present)}
\item{nsbjs}{the number of subjects}
\item{nobs}{the total number of observations}
\item{se.betaf}{the standard errors for fixed regression coefficients}
\item{se.betarTC}{the standard errors for TC random coefficients (if present)}
\item{se.betarTV}{the standard errors for TV random coefficients (if present)}
\item{se.Mprob}{the standard errors for the prior probabilities of the finite mixture associated to TC random coefficients (if present)}
\item{se.Init}{the standard errors for the initial probabilities of the hidden Markov chain associated to TV random coefficients(if present)}
\item{se.Trans}{the standard errors for the transition probabilities of the hidden Markov chain associated to TV random coefficients (if present)}
\item{se.scale}{the standard error for the scale parameter}
\item{postTC}{estimated posterior probabilities for the finite mixture components associated to TC random coefficients}
\item{postTV}{estimated posterior probabilities for the hidden states associated to TV random coefficients}
\item{miss}{the missingness type}
\item{model}{the estimated model}
\item{call}{the matched call}
}
\description{
Estimate a finite mixture of linear quantile regression models with TC and/or TV discrete random coefficients, for a given number of components and/or states
}
\details{
The function computes ML estimates for a linear quantile mixture model with on TC and/or TV random coefficients.
Estimates are derived by maximizing the (log-)likelihood of an asymmetric Laplace regression, where the location parameter is modeled as a function of fixed coefficients, together with TC, TV, or TC and TV discrete random coefficients, as proposed by Alfo' et. al (2017), Farcomeni (2012), and Marino et. al (2018), respectively.

The function requires data in long-format and two additional columns indicating the group identifier and the time occasion.
The model is specified by means of the arguments \code{formula}, \code{formulaTC}, and \code{formulaTV}:
\code{formula} is associated to fixed coefficients; \code{formulaTC} is associated to TC random coefficients; \code{formulaTV} is associated to TV random coefficients.
In this latter, only TC variables (predictors) are allowed.

The function allows for missing data, including dropouts (monotone missing data) and intermittent missingness, under a missing-at-random assumption.
Note that, when TV random coefficients are considered, intermittent missingness may cause biased inference.

If \code{se=TRUE}, standard errors based on a block bootstrap procedure are computed.
}
\examples{
outTC = lqmix(formula=meas~trt+time+trt:time,randomTC=~1,
              group="id",time="time",G=2,data=pain,se=TRUE,R=10)

\donttest{
outTV = lqmix(formula=meas~trt+time+trt:time,randomTV=~1,
              group="id",time="time",m=2,data=pain,R=10)

outTCTV = lqmix(formula=meas~trt+time+trt:time,randomTC=~time,
                    randomTV=~1,group="id",time="time",m=2,G=2,data=pain,R=10)
}
}
\references{
{
  \insertRef{ref:lqmixTCTV}{lqmix}
}

{
  \insertRef{ref:mhmm1}{lqmix}
}

{
  \insertRef{ref:mhmm2}{lqmix}
}
}
