% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{origin.Euclidean}
\alias{origin.Euclidean}
\alias{origin}
\alias{origin.L2}
\alias{origin.HS}
\alias{origin.Dens}
\alias{origin.SO}
\alias{origin.SPD}
\alias{origin.Sphere}
\title{Returns the origin of the manifold}
\usage{
\method{origin}{Euclidean}(mfd, dimIntrinsic, ...)

origin(mfd, dimIntrinsic, ...)

\method{origin}{L2}(mfd, dimIntrinsic, ...)

\method{origin}{HS}(mfd, dimIntrinsic, ...)

\method{origin}{Dens}(mfd, dimIntrinsic, ...)

\method{origin}{SO}(mfd, dimIntrinsic, ...)

\method{origin}{SPD}(mfd, dimIntrinsic, ...)

\method{origin}{Sphere}(mfd, dimIntrinsic, ...)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{dimIntrinsic}{An integer for the intrinsic dimension}

\item{...}{Passed into specific methods}
}
\value{
A matrix with 1 column, a designation of the origin on the manifold
}
\description{
Each manifold defined in this package has been designated a more or less reasonable choice of origin.
}
\section{Methods (by class)}{
\itemize{
\item \code{origin(Euclidean)}: Method

\item \code{origin(L2)}: Method

\item \code{origin(HS)}: Method

\item \code{origin(Dens)}: The uniform density

\item \code{origin(SO)}: The origin has 1 in the first ambient coordinate and 0 otherwise.

\item \code{origin(SPD)}: The origin is the identity matrix but vectorized.

\item \code{origin(Sphere)}: The origin has 1 in the first ambient coordinate and 0 otherwise.

}}
