% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{benchmark_analysis}
\alias{benchmark_analysis}
\title{Benchmark Analysis Performance}
\usage{
benchmark_analysis(
  scale = "huc8",
  year = 2016,
  nutrients = "nitrogen",
  n_runs = 3,
  include_wwtp = TRUE
)
}
\arguments{
\item{scale}{Character. Spatial scale}

\item{year}{Numeric. Year to test}

\item{nutrients}{Character vector. Nutrients to analyze}

\item{n_runs}{Integer. Number of benchmark runs (default: 3)}

\item{include_wwtp}{Logical. Include WWTP processing}
}
\value{
List with timing statistics and memory usage
}
\description{
Test analysis speed and memory usage
}
\examples{
\donttest{
# Benchmark HUC8 analysis - use smaller scale for faster testing
benchmark <- benchmark_analysis(
  scale = "county",  # Use county for faster testing
  year = 2016,
  nutrients = "nitrogen",
  n_runs = 2  # Reduce runs for faster testing
)
print(benchmark)
}
}
