% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_documentation.R
\name{citation_info}
\alias{citation_info}
\title{Display Package Citation Information}
\usage{
citation_info()
}
\value{
No return value, called for side effects. The function prints
citation information to the console including:
\itemize{
\item Package citation with version and OSF repository
\item Research methodology paper citation
\item NuGIS data source attribution
\item EPA WWTP data source attribution
\item Contact information for data sources
}
}
\description{
Provides citation information for the package and data sources.
Prints formatted citation text to the console for the manureshed package,
the underlying research methodology paper (Akanbi et al., 2026), and the
primary data sources (NuGIS agricultural data and EPA WWTP discharge data).
The function is designed for users to easily obtain proper citations for
publications and reports.
}
\details{
This function takes no arguments. It prints citation information directly
to the console using message() functions, which can be suppressed with
suppressMessages() if needed.
}
\note{
This function requires no arguments and can be called simply as
\code{citation_info()}.
}
\examples{
\donttest{
# Display citation information
citation_info()
}

}
\seealso{
\code{\link{check_builtin_data}} for data availability,
\code{\link{health_check}} for package diagnostics
}
