% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{motif_node}
\alias{motif_node}
\alias{node_by_tie}
\alias{node_by_dyad}
\alias{node_by_triad}
\alias{node_by_tetrad}
\alias{node_by_path}
\title{Motifs at the nodal level}
\usage{
node_by_tie(.data)

node_by_dyad(.data)

node_by_triad(.data)

node_by_tetrad(.data)

node_by_path(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions include ways to take a census of the positions of nodes
in a network:
\itemize{
\item \code{node_by_tie()} returns a census of the ties in a network.
For directed networks, out-ties and in-ties are bound together.
For multiplex networks, the various types of ties are bound together.
\item \code{node_by_triad()} returns a census of the triad configurations
nodes are embedded in.
\item \code{node_by_tetrad()} returns a census of nodes' positions
in motifs of four nodes.
\item \code{node_by_path()} returns the shortest path lengths
of each node to every other node in the network.
}
}
\section{Tetrad census}{

The nodal tetrad census counts the number of four-node configurations
that each node is embedded in.
The function returns a matrix with a special naming convention:
\itemize{
\item E4 (aka co-K4): This is an empty set of four nodes; no ties
\item I4 (aka co-diamond): This is a set of four nodes with just one tie
\item H4 (aka co-C4): This set of four nodes includes two non-adjacent ties
\item L4 (aka co-paw): This set of four nodes includes two adjacent ties
\item D4 (aka co-claw): This set of four nodes includes three adjacent ties,
in the form of a triangle with one isolate
\item U4 (aka P4, four-actor line): This set of four nodes includes three ties
arranged in a line
\item Y4 (aka claw): This set of four nodes includes three ties all adjacent
to a single node
\item P4 (aka paw, kite): This set of four nodes includes four ties arranged
as a triangle with an extra tie hanging off of one of the nodes
\item C4 (aka bifan): This is a symmetric box or 4-cycle or set of shared choices
\item Z4 (aka diamond): This resembles C4 but with an extra tie cutting across the box
\item X4 (aka K4): This resembles C4 but with two extra ties cutting across the box;
a realisation of all possible ties
}

Graphs of these motifs can be shown using
\code{plot(node_by_tetrad(ison_southern_women))}.
}

\examples{
task_eg <- to_named(to_uniplex(ison_algebra, "tasks"))
(tie_cen <- node_by_tie(task_eg))
node_by_dyad(ison_networkers)
(triad_cen <- node_by_triad(task_eg))
node_by_tetrad(ison_southern_women)
node_by_path(ison_adolescents)
node_by_path(ison_southern_women)
}
\references{
\subsection{On the dyad census}{

Holland, Paul W., and Samuel Leinhardt. 1970.
"A Method for Detecting Structure in Sociometric Data".
\emph{American Journal of Sociology}, 76: 492-513.
\doi{10.1016/B978-0-12-442450-0.50028-6}
}

\subsection{On the triad census}{

Davis, James A., and Samuel Leinhardt. 1967.
“\href{https://files.eric.ed.gov/fulltext/ED024086.pdf}{The Structure of Positive Interpersonal Relations in Small Groups}.” 55.
}

\subsection{On the tetrad census}{

Ortmann, Mark, and Ulrik Brandes. 2017.
“Efficient Orbit-Aware Triad and Quad Census in Directed and Undirected Graphs.”
\emph{Applied Network Science} 2(1):13.
\doi{10.1007/s41109-017-0027-2}.

McMillan, Cassie, and Diane Felmlee. 2020.
"Beyond Dyads and Triads: A Comparison of Tetrads in Twenty Social Networks".
\emph{Social Psychology Quarterly} 83(4): 383-404.
\doi{10.1177/0190272520944151}
}

\subsection{On paths}{

Dijkstra, Edsger W. 1959.
"A note on two problems in connexion with graphs".
\emph{Numerische Mathematik} 1, 269-71.
\doi{10.1007/BF01386390}.

Opsahl, Tore, Filip Agneessens, and John Skvoretz. 2010.
"Node centrality in weighted networks: Generalizing degree and shortest paths".
\emph{Social Networks} 32(3): 245-51.
\doi{10.1016/j.socnet.2010.03.006}.
}
}
\seealso{
Other motifs: 
\code{\link{motif_brokerage}},
\code{\link{motif_diffusion}},
\code{\link{motif_net}}
}
\concept{motifs}
