% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{add_globe_minimap}
\alias{add_globe_minimap}
\title{Add a Globe Minimap to a map}
\usage{
add_globe_minimap(
  map,
  position = "bottom-right",
  globe_size = 82,
  land_color = "white",
  water_color = "rgba(30 40 70/60\%)",
  marker_color = "#ff2233",
  marker_size = 1
)
}
\arguments{
\item{map}{A \code{mapboxgl} or \code{maplibre} object.}

\item{position}{A string specifying the position of the minimap.}

\item{globe_size}{Number of pixels for the diameter of the globe. Default is 82.}

\item{land_color}{HTML color to use for land areas on the globe. Default is 'white'.}

\item{water_color}{HTML color to use for water areas on the globe. Default is 'rgba(30 40 70/60\%)'.}

\item{marker_color}{HTML color to use for the center point marker. Default is '#ff2233'.}

\item{marker_size}{Scale ratio for the center point marker. Default is 1.}
}
\value{
The modified map object with the globe minimap added.
}
\description{
This function adds a globe minimap control to a Mapbox GL or Maplibre map.
}
\examples{
\dontrun{
library(mapgl)

m <- mapboxgl() \%>\%
    add_globe_minimap()

m <- maplibre() \%>\%
    add_globe_minimap()
}
}
