% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_simulate.R
\name{cross_simulate}
\alias{cross_simulate}
\title{Simulate an autopolyploid full-sib population}
\usage{
cross_simulate(
  parental.phases,
  map.length,
  n.ind,
  draw = FALSE,
  file = "output.pdf",
  prefix = NULL,
  seed = NULL,
  width = 12,
  height = 6,
  prob.P = NULL,
  prob.Q = NULL
)
}
\arguments{
\item{parental.phases}{a list containing the linkage phase information for both parents}

\item{map.length}{the map length}

\item{n.ind}{number of individuals in the offspring}

\item{draw}{if \code{TRUE}, draws a graphical representation of the
parental map, including the linkage phase configuration, in a
pdf output (default = FALSE)}

\item{file}{name of the output file. It is ignored if
\code{draw = TRUE}}

\item{prefix}{prefix used in all marker names.}

\item{seed}{random number generator seed (default = NULL)}

\item{width}{the width of the graphics region in inches (default = 12)}

\item{height}{the height of the graphics region in inches (default = 6)}

\item{prob.P}{a vector indicating the proportion of preferential
pairing in parent P (currently ignored)}

\item{prob.Q}{a vector indicating the proportion of preferential
pairing in parent Q (currently ignored)}
}
\value{
an object of class \code{mappoly.data}. See
    \code{\link[mappoly]{read_geno}} for more information
}
\description{
Simulate an autopolyploid full-sib population with one or two 
informative parents under random chromosome segregation.
}
\details{
\code{parental.phases.p} and \code{parental.phases.q} are lists of vectors
 containing linkage phase configurations. Each vector contains the
 numbers of the homologous chromosomes in which the alleles are
 located. For instance, a vector containing \eqn{(1,3,4)} means that
 the marker has three doses located in the chromosomes 1, 3 and 4. For
 zero doses, use 0.
 For more sophisticated simulations, we strongly recommend using PedigreeSim V2.0
 \url{https://github.com/PBR/pedigreeSim}
}
\examples{
    h.temp <- sim_homologous(ploidy = 6, n.mrk = 20)
    fake.poly.dat <- cross_simulate(h.temp, map.length = 100, n.ind = 200)
    plot(fake.poly.dat)
                                   
                                  
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
