% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcse.R
\name{ess}
\alias{ess}
\title{Univariate effective sample size (ESS) as described in Gong and Flgal (2015).}
\usage{
ess(x, g = NULL, ...)
}
\arguments{
\item{x}{a matrix or data frame of Markov chain output. Number of rows is the Monte
Carlo sample size.}

\item{g}{a function that represents features of interest. \code{g} is applied to each row of x and thus
\code{g} should take a vector input only. Ifcode{g} is \code{NULL}, \code{g} is set to be identity, which is estimation
 of the mean of the target density.}

\item{...}{arguments passed on to the \code{mcse.mat} function. For example method = \dQuote{\code{tukey}} and size =
\dQuote{\code{cuberoot}} can be used.}
}
\value{
The function returns the estimated effective sample size for each component of \code{g}.
}
\description{
Estimate the effective sample size (ESS) of a Markov chain as described in Gong and Flegal (2015).
}
\details{
ESS is the size of an iid sample with the same variance as the current sample for estimating the expectation of g. ESS is given by
\deqn{ESS = n \frac{\lambda^{2}}{\sigma^{2}}} where \eqn{\lambda^{2}} is the sample variance and
\eqn{\sigma^{2}} is an estimate of the variance in the Markov chain central limit theorem. The denominator by default
is a batch means estimator, but the default can be changed with the `method` argument.
}
\references{
Gong, L. and Flegal, J. M. (2015) A practical sequential stopping rule for high-dimensional
Markov chain Monte Carlo, \emph{Journal of Computational and Graphical Statistics},  \bold{25}, 684—700.
}
\seealso{
\code{\link{minESS}}, which calculates the minimum effective samples required for the problem.
\code{\link{multiESS}}, which calculates multivariate effective sample size using a Markov chain
and a function \code{g}.
}
