% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spwb_land.R
\name{plot.spwb_land}
\alias{plot.spwb_land}
\alias{plot.growth_land}
\alias{plot.fordyn_land}
\title{Displays watershed-level simulation results}
\usage{
\method{plot}{spwb_land}(x, type = "Hydrograph_Hietograph", dates = NULL, summary.freq = NULL, ...)

\method{plot}{growth_land}(x, type = "Hydrograph_Hietograph", dates = NULL, summary.freq = NULL, ...)

\method{plot}{fordyn_land}(x, type = "Hydrograph_Hietograph", dates = NULL, summary.freq = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{spwb_land}, \code{growth_land} or \code{fordyn_land}.}

\item{type}{The information to be plotted (see details)}

\item{dates}{A Date vector with a subset of dates to be plotted.}

\item{summary.freq}{Frequency of summary statistics (see \code{\link{cut.Date}}).}

\item{...}{Additional parameters for function \code{plot} (not used).}
}
\value{
A ggplot object
}
\description{
Plots time series of the watershed-level balance results of simulations with \code{spwb_land}, \code{growth_land} or \code{fordyn_land}.
}
\details{
The following plots are currently available:
\itemize{
\item{\code{"Hydrograph_Hietograph"}: A combination of hydrograph and hietograph (in a secondary, reversed, axis).}
\item{\code{"PET_Precipitation"}: Potential evapotranspiration, rainfall and snow.}
\item{\code{"Export"}: Water exported through different fluxes.}
\item{\code{"Evapotranspiration"}: Interception, woody transpiration, herb transpiration and soil evaporation.}
}
}
\seealso{
\code{\link{spwb_land}}, \code{\link{growth_land}}, \code{\link{fordyn_land}},
\code{\link{plot_summary}}, \code{\link{shinyplot_land}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
