% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_contour_fill.R, R/stat_contour_fill.R
\docType{data}
\name{geom_contour_fill}
\alias{geom_contour_fill}
\alias{stat_contour_fill}
\alias{StatContourFill}
\title{Filled 2d contours of a 3d surface}
\usage{
geom_contour_fill(
  mapping = NULL,
  data = NULL,
  stat = "ContourFill",
  position = "identity",
  ...,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  proj = NULL,
  proj.latlon = TRUE,
  clip = NULL,
  kriging = FALSE,
  global.breaks = TRUE,
  na.fill = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_contour_fill(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  ...,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  global.breaks = TRUE,
  proj = NULL,
  proj.latlon = TRUE,
  clip = NULL,
  kriging = FALSE,
  na.fill = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{breaks}{numeric vector of breaks}

\item{bins}{Number of evenly spaced breaks.}

\item{binwidth}{Distance between breaks.}

\item{proj}{The projection to which to project the contours to.
It can be either a projection string or a function to apply to the whole
contour dataset.}

\item{proj.latlon}{Logical indicating if the projection step should project
from a cartographic projection to a lon/lat grid or the other way around.}

\item{clip}{A simple features object to be used as a clip. Contours are only
drawn in the interior of this polygon.}

\item{kriging}{Whether to perform ordinary kriging before contouring.
Use this if you want to use contours with irregularly spaced data.
If \code{FALSE}, no kriging is performed. If \code{TRUE}, kriging will be performed with
40 points. If a numeric, kriging will be performed with \code{kriging} points.}

\item{global.breaks}{Logical indicating whether \code{breaks} should be computed for the whole
data or for each grouping.}

\item{na.fill}{How to fill missing values.
\itemize{
\item \code{FALSE} for letting the computation fail with no interpolation
\item \code{TRUE} for imputing missing values with \link{Impute2D}
\item A numeric value for constant imputation
\item A function that takes a vector and returns a numeric (e.g. \code{mean})
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
While ggplot2's \code{\link[ggplot2]{geom_contour}} can plot nice contours, it
doesn't work with the polygon geom. This stat makes some small manipulation
of the data to ensure that all contours are closed and also computes a new
aesthetic \code{int.level}, which differs from \code{level} (computed by
\link[ggplot2:geom_contour]{ggplot2::geom_contour}) in that represents
the value of the \code{z} aesthetic \emph{inside} the contour instead of at the edge.
It also computes breaks globally instead of per panel, so that faceted plots
have all the same binwidth.
}
\section{Aesthetics}{

\code{geom_contour_fill} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{size}
\item \code{weight}
}
}

\section{Computed variables}{

\describe{
\item{level}{An ordered factor that represents bin ranges.}
\item{level_d}{Same as \code{level}, but automatically uses \code{\link[=scale_fill_discretised]{scale_fill_discretised()}}}
\item{level_low,level_high,level_mid}{Lower and upper bin boundaries for each band, as well the mid point between the boundaries.}
}
}

\examples{
\dontshow{if (requireNamespace("reshape2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{data.table::setDTthreads(1)}

library(ggplot2)
surface <- reshape2::melt(volcano)
ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill() +
  geom_contour(color = "black", size = 0.1)

ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill(aes(fill = after_stat(level)))

ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill(aes(fill = after_stat(level_d)))
\dontshow{\}) # examplesIf}
}
\seealso{
Other ggplot2 helpers: 
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
\keyword{datasets}
