% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_tree--mapping.R
\name{rescale}
\alias{rescale}
\title{Rescale numeric vector to have specified minimum and maximum.}
\usage{
rescale(
  x,
  to = c(0, 1),
  from = range(x, na.rm = TRUE, finite = TRUE),
  hard_bounds = TRUE
)
}
\arguments{
\item{x}{values to rescale}

\item{to}{range to scale to}

\item{from}{range of values the x could have been}

\item{hard_bounds}{If \code{TRUE}, all values will be forced into the range of \code{to}.}
}
\description{
Rescale numeric vector to have specified minimum and maximum, but allow for hard boundaries.
It is a slightly modified version of scales::rescale, incorporating scales::zero_range, both by Hadley Wickham used under the conditions of the MIT license.
}
\keyword{internal}
