% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_mid.R
\name{summary.mid}
\alias{summary.mid}
\title{Summarize MID Models}
\usage{
\method{summary}{mid}(object, digits = max(3L, getOption("digits") - 2L), top.n = 10L, ...)
}
\arguments{
\item{object}{a "mid" object to be summarized.}

\item{digits}{the number of significant digits for printing numeric values.}

\item{top.n}{the maximum number of top-ranked terms to be printed in the MID importance table.}

\item{...}{arguments to be passed to other methods (not used in this method).}
}
\value{
\code{summary.mid()} returns the original "mid" object invisibly.
}
\description{
For "mid" objects, an S3 method of \code{summary()} prints a comprehensive summary of a fitted MID Model.
}
\details{
The S3 method \code{summary.mid()} generates a comprehensive overview of the fitted MID model.
The output includes the following components:
(1) "Call" - the function call used to fit the MID model.
(2) "Uninterpreted Variation Ratio" - a key metric indicating the proportion of the target model's variance that is not explained by the MID model.
Lower values suggest a better fit.
(3) "Residuals" - a five-number summary (Min, 1Q, Median, 3Q, Max) of the working residuals.
This aids in assessing model fit and identifying potential biases.
(4) "Encoding" - a summary of the encoding schemes used for each variable in the MID model.
(5) "Importance" - a list of the top terms ranked by their MID importance, which quantifies their average contribution to the model's predictions.
}
\examples{
# Summarize a fitted MID model
data(cars, package = "datasets")
mid <- interpret(dist ~ speed, cars)
summary(mid)
}
\seealso{
\code{\link{interpret}}, \code{\link{print.mid}}
}
