% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivalence_theorem.R
\name{check_equivalence_theorem}
\alias{check_equivalence_theorem}
\title{Check Equivalence Theorem for Optimal Design}
\usage{
check_equivalence_theorem(best_particle, model_set, design_info, seed = 42)
}
\arguments{
\item{best_particle}{A vector containing the best particle's position (i.e., stress levels and transformed allocated proportion).}

\item{model_set}{A matrix of models, including parameters and distribution, that maximize the optimality criteria with the given best particle's position.}

\item{design_info}{A list containing design parameters such as factor levels, number of units, and other settings.}

\item{seed}{Seed for reproducibility}
}
\value{
\describe{
\item{max_directional_derivative}{Maximum directional derivative within design space.}
\item{model_set}{The model set that is input.}
\item{model_weight}{The weight assigned to each model in the model set.}
\item{equivalence_data}{Generated designs and their corresponding directional derivative given the optimal design \code{best_particle}. Each design is a combination of factors with value in [0, 1]. These designs are data for plotting equivalence theorem plot.}
}
}
\description{
Evaluates whether a design satisfies the equivalence theorem.
}
\examples{
design_info <- set_design_info(k_levels=2, j_factor=1, n_unit=300, 
                               censor_time=183, p=0.1, use_cond=0, sigma=0.6)
                               
best_particle <- c(0.682, 1, 0.706)

model_set <- rbind(
  c(0.01, 0.9, 1),
  c(0.01, 0.99, 2))

equi <- check_equivalence_theorem (best_particle=best_particle, 
                                    model_set=model_set, 
                                    design_info=design_info)

equi$max_directional_derivative

}
\references{
\enumerate{
  \item Müller, C. H., & Pázman, A. (1998). Applications of necessary and sufficient conditions for maximin efficient designs. Metrika, 48, 1–19.
  \item Huang, M.-N. L., & Lin, C.-S. (2006). Minimax and maximin efficient designs for estimating the location-shift parameter of parallel models with dual responses. Journal of Multivariate Analysis, 97(1), 198–210.
}
}
