% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.lm.model.select.R
\name{miss.lm.model.select}
\alias{miss.lm.model.select}
\title{miss.lm.model.select}
\usage{
miss.lm.model.select(Y, X)
}
\arguments{
\item{Y}{Response vector \eqn{N \times 1}{N * 1}}

\item{X}{Design matrix with missingness \eqn{N \times p}{N * p}}
}
\value{
An object of class "\code{miss.lm}".
}
\description{
Model selection for the linear regression model with missing data.
}
\examples{
# Generate complete data
set.seed(1)
mu.X <- c(1, 1)
Sigma.X <- matrix(c(1, 1, 1, 4), nrow = 2)
n <- 50
p <- 2
X.complete <- matrix(rnorm(n*p), nrow=n)\%*\%chol(Sigma.X) +
              matrix(rep(mu.X,n), nrow=n, byrow = TRUE)
b <- c(2, 0, -1)
sigma.eps <- 0.25
y <- cbind(rep(1, n), X.complete) \%*\% b + rnorm(n, 0, sigma.eps)

# Add missing values
p.miss <- 0.10
patterns <- runif(n*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA

# model selection
miss.model = miss.lm.model.select(y, X.obs)
print(miss.model)
}
