% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_alpha_min.R
\name{compute_alpha_min}
\alias{compute_alpha_min}
\title{Compute Minimum Possible Alpha Value}
\usage{
compute_alpha_min(
  n_person,
  sigma_x_info,
  sigma_y_info,
  score_max = 1,
  alpha_lb = 0,
  alpha_ub = 1,
  tol = 0.001,
  num_try = 1,
  method = "GA",
  ...
)
}
\arguments{
\item{n_person}{An integer specifying the number of individuals (rows) in the score matrix.}

\item{sigma_x_info}{A list containing the quadratic function information for sigma_x. It should include:
\itemize{
\item A matrix representing the quadratic coefficients for sigma_x.
\item A vector representing the linear coefficients for sigma_x.
\item A scalar constant term for sigma_x.
}}

\item{sigma_y_info}{A list containing the quadratic function information for sigma_y. It should include:
\itemize{
\item A matrix representing the quadratic coefficients for sigma_y.
\item A vector representing the linear coefficients for sigma_y.
\item A scalar constant term for sigma_y.
}}

\item{score_max}{An integer specifying the largest possible score for any test item. Default is 1.}

\item{alpha_lb}{A numeric value specifying the lower bound of alpha, usually set to 0.0.}

\item{alpha_ub}{A numeric value specifying the upper bound of alpha, usually set to 1.0.}

\item{tol}{A numeric value representing the desired accuracy for narrowing down the bounds between \code{alpha_lb} and \code{alpha_ub}. Default is 1e-3.}

\item{num_try}{An integer specifying the number of times to run the optimization algorithm in each iteration. Default is 1.}

\item{method}{A character string specifying the optimization method to be used. Options are 'GA' (Genetic Algorithm), 'DEoptim' (Differential Evolution), and 'nloptr' (Sequential Least Squares Programming). Default is 'GA'.}

\item{...}{Additional parameters passed to the optimization algorithm.}
}
\value{
A numeric value representing the minimum possible Cronbach's alpha.
}
\description{
This function calculates the minimum possible value of Cronbach's alpha by using
a binary search algorithm with optimization methods. The function iteratively narrows
the bounds of alpha until the desired tolerance level is reached.
}
\details{
This function finds the minimum possible Cronbach's alpha by using an iterative binary search algorithm.
It evaluates the feasibility of each midpoint value of alpha by solving the corresponding optimization problem with the chosen method.

The optimization methods can be specified via the \code{method} parameter, and additional control parameters for the optimization methods can be passed through the \code{...} argument. The function adjusts the upper and lower bounds of alpha until the tolerance criterion is met.
}
\seealso{
\code{\link{compute_alpha_max}}, \code{\link{examine_alpha_bound}}
}
