% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_glmnet.R
\name{LearnerGlmnet}
\alias{LearnerGlmnet}
\title{R6 Class to construct a Glmnet learner}
\description{
The \code{LearnerGlmnet} class is the interface to the \code{glmnet} R package for use
with the \code{mlexperiments} package.
}
\details{
Optimization metric:
Can be used with
\itemize{
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}
}
\examples{
# binary classification

library(mlbench)
data("PimaIndiansDiabetes2")
dataset <- PimaIndiansDiabetes2 |>
  data.table::as.data.table() |>
  na.omit()

seed <- 123
feature_cols <- colnames(dataset)[1:8]

train_x <- model.matrix(
  ~ -1 + .,
  dataset[, .SD, .SDcols = feature_cols]
)
train_y <- as.integer(dataset[, get("diabetes")]) - 1L

fold_list <- splitTools::create_folds(
  y = train_y,
  k = 3,
  type = "stratified",
  seed = seed
)
glmnet_cv <- mlexperiments::MLCrossValidation$new(
  learner = mllrnrs::LearnerGlmnet$new(
    metric_optimization_higher_better = FALSE
  ),
  fold_list = fold_list,
  ncores = 2,
  seed = 123
)
glmnet_cv$learner_args <- list(
  alpha = 1,
  lambda = 0.1,
  family = "binomial",
  type.measure = "class",
  standardize = TRUE
)
glmnet_cv$predict_args <- list(type = "response")
glmnet_cv$performance_metric_args <- list(positive = "1")
glmnet_cv$performance_metric <- mlexperiments::metric("auc")

# set data
glmnet_cv$set_data(
  x = train_x,
  y = train_y
)

glmnet_cv$execute()

## ------------------------------------------------
## Method `LearnerGlmnet$new`
## ------------------------------------------------

LearnerGlmnet$new(metric_optimization_higher_better = FALSE)

}
\seealso{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}}, \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerGlmnet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerGlmnet-new}{\code{LearnerGlmnet$new()}}
\item \href{#method-LearnerGlmnet-clone}{\code{LearnerGlmnet$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerGlmnet-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerGlmnet-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerGlmnet} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerGlmnet$new(metric_optimization_higher_better)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric_optimization_higher_better}}{A logical. Defines the direction
of the optimization metric used throughout the hyperparameter
optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LearnerGlmnet} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerGlmnet$new(metric_optimization_higher_better = FALSE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerGlmnet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerGlmnet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerGlmnet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
